// npm package: sweetalert2
// github link: https://github.com/sweetalert2/sweetalert2

$(function () {

    showSwal = function (type, id) {
        'use strict';
        if (type === 'able') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-start',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });

            Toast.fire({
                icon: 'success',
                title: 'کانفیگ با موفقیت فعال شد'
            })
            setTimeout(function () {
                window.location.replace("/changeStatus/" + id)
            }, 1000)

        }

        else if (type === 'disable') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-start',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });

            Toast.fire({
                icon: 'success',
                title: 'کانفیگ با موفقیت غیر فعال شد'
            })
            setTimeout(function () {
                window.location.replace("/changeStatus/" + id)
            }, 1000)
        }

        else if (type === 'addFlag') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-start',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });

            Toast.fire({
                icon: 'success',
                title: 'پرچم با موفقیت اضافه شد'
            })
            setTimeout(function () {
                window.location.replace("/flag/" + id)
            }, 1000)
        }

        else if (type === 'deleteFlag') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-start',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });

            Toast.fire({
                icon: 'success',
                title: 'پرچم با موفقیت حذف شد'
            })
            setTimeout(function () {
                window.location.replace("/flag/" + id)
            }, 1000)
        }

        else if (type === 'addSubset') {
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-start',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: true,
            });

            Toast.fire({
                icon: 'success',
                title: 'زیر مجموعه با موفقیت اضافه شد'
            })

        }


        else if (type === 'reset') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "بعد از تمدید هزینه آن به صورت حساب شما اضافه میشود",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، تمدید شود!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'تمدید شد!',
                        'کانفیگ مورد نظر شما تمدید شد!',
                        'success'
                    )
                    setTimeout(function () {
                        window.location.replace('/extension/' + id + '?day=yes')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما تمدید کانفیگ را لغو کردید :)',
                        'error'
                    )
                }
            })
        }


        else if (type === 'deleteConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "بعد از حذف قادر به بازگردانی اطلاعات کانفیگ نخواهید بود",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، حذف شود!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'حذف شد!',
                        'کانفیگ مورد نظر شما حذف شد!',
                        'success'
                    )
                    setTimeout(function () {
                        window.location.replace('/deleteUser/' + id)
                    }, 2000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما تمدید کانفیگ را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'activeUser') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های این کاربر غیرفعال میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، غیرفعال شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'غیرفعال شدند!',
                        'تمامی کانفیگ های کاربر ظرف چند دقیقه آینده غیرفعال میشنود!',
                        'success'
                    )
                    setTimeout(function () {
                        window.location.replace('/lock/' + id + '?mode=lock')
                    }, 1000)

                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما غیرفعال کردن کانفیگ های کاربر را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'deActiveUser') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های این کاربر فعال میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، فعال شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'غیرفعال شدند!',
                        'تمامی کانفیگ های کاربر ظرف چند دقیقه آینده فعال میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/lock/' + id + '?mode=unlock')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما فعال کردن کانفیگ های کاربر را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'handExamineExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های منقضی شده پاک میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک میشوند!',
                        'تمامی کانفیگ های منقضی شده ظرف چند دقیقه آینده پاک میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/servers?mode=review')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های منقضی شده را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'autoExamineExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های منقضی شده پاک میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک میشوند!',
                        'تمامی کانفیگ های منقضی شده ظرف چند دقیقه آینده پاک میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/examineConfig?mode=on')
                    }, 2000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های منقضی شده را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'getAllInboundsAndDeleteExpiredConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های غیر فعال در xui پاک میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک میشوند!',
                        'تمامی کانفیگ های غیرفعال در xui ظرف چند دقیقه آینده پاک میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/GAIANEC')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های غیرفعال را لغو کردید :)',
                        'error'
                    )
                }
            })
        } else if (type === 'deleteExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "لاشه ی تمامی کانفیگ های منقضی شده پاک میشود",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک شدند!',
                        'لاشه تمامی کانفیگ های منقضی شده پاک شد!',
                        'success'
                    )
                    setTimeout(function () {
                        window.location.replace('/deleteAfter4day')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های غیرفعال را لغو کردید :)',
                        'error'
                    )
                }
            })
        }

    }

    showWireGuard = function (type, id) {
        'use strict';
        if (type === 'handExamineExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های منقضی شده پاک میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک میشوند!',
                        'تمامی کانفیگ های منقضی شده ظرف چند دقیقه آینده پاک میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/servers?mode=review')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های منقضی شده را لغو کردید :)',
                        'error'
                    )
                }
            })
        }
        else if (type === 'autoExamineExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "تمامی کانفیگ های منقضی شده پاک میشوند",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک میشوند!',
                        'تمامی کانفیگ های منقضی شده ظرف چند دقیقه آینده پاک میشنود!',
                        'success'
                    )

                    setTimeout(function () {
                        window.location.replace('/examineConfig?mode=on')
                    }, 2000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های منقضی شده را لغو کردید :)',
                        'error'
                    )
                }
            })
        }
        else if (type === 'deleteExpireConfig') {
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger me-2'
                },
                buttonsStyling: false,
            })

            swalWithBootstrapButtons.fire({
                title: 'آیا مطمئن هستید؟',
                text: "لاشه ی تمامی کانفیگ های منقضی شده پاک میشود",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonClass: 'me-2',
                onfirmButtonText: 'بله، پاک شوند!',
                cancelButtonText: 'نه، لغو شود',
                reverseButtons: true,

            }).then((result) => {
                if (result.value) {
                    swalWithBootstrapButtons.fire(
                        'پاک شدند!',
                        'لاشه تمامی کانفیگ های منقضی شده پاک شد!',
                        'success'
                    )
                    setTimeout(function () {
                        window.location.replace('/deleteExpireConfig')
                    }, 1000)
                } else if (
                    // Read more about handling dismissals
                    result.dismiss === Swal.DismissReason.cancel
                ) {
                    swalWithBootstrapButtons.fire(
                        'لغو شد',
                        'شما پاک کردن کانفیگ های غیرفعال را لغو کردید :)',
                        'error'
                    )
                }
            })
        }

    }

    $("#username").on("keypress", function (event) {

        // Disallow anything not matching the regex pattern (A to Z uppercase, a to z lowercase and white space)
        // For more on JavaScript Regular Expressions, look here: https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions
        var englishAlphabetAndWhiteSpace = /[A-Za-z-1-9 ]/g;

        // Retrieving the key from the char code passed in event.which
        // For more info on even.which, look here: http://stackoverflow.com/q/3050984/114029
        var key = String.fromCharCode(event.which);

        //alert(event.keyCode);

        // For the keyCodes, look here: http://stackoverflow.com/a/3781360/114029
        // keyCode == 8  is backspace
        // keyCode == 37 is left arrow
        // keyCode == 39 is right arrow
        // englishAlphabetAndWhiteSpace.test(key) does the matching, that is, test the key just typed against the regex pattern
        if (event.keyCode == 8 || event.keyCode == 37 || event.keyCode == 39 || englishAlphabetAndWhiteSpace.test(key)) {
            return true;
        }

        // If we got this far, just return false because a disallowed key was typed.
        return false;
    });
    $("#password").on("keypress", function (event) {

        // Disallow anything not matching the regex pattern (A to Z uppercase, a to z lowercase and white space)
        // For more on JavaScript Regular Expressions, look here: https://developer.mozilla.org/en-US/docs/JavaScript/Guide/Regular_Expressions
        var englishAlphabetAndWhiteSpace = /[A-Za-z-1-9 ]/g;

        // Retrieving the key from the char code passed in event.which
        // For more info on even.which, look here: http://stackoverflow.com/q/3050984/114029
        var key = String.fromCharCode(event.which);

        //alert(event.keyCode);

        // For the keyCodes, look here: http://stackoverflow.com/a/3781360/114029
        // keyCode == 8  is backspace
        // keyCode == 37 is left arrow
        // keyCode == 39 is right arrow
        // englishAlphabetAndWhiteSpace.test(key) does the matching, that is, test the key just typed against the regex pattern
        if (event.keyCode == 8 || event.keyCode == 37 || event.keyCode == 39 || englishAlphabetAndWhiteSpace.test(key)) {
            return true;
        }

        // If we got this far, just return false because a disallowed key was typed.
        return false;
    });

    $('#mytextbox').on("paste", function (e) {
        e.preventDefault();
    });

});